package parser;

/**
 * Grammar non-terminal -- E ::= num E1
 */
public class E {
    /**
     * Number object.
     */
    private NumToken _num;

    /**
     * E1 object.
     */
    private E1 _e1;

    /**
     * Constructor for the E grammar non-terminal.
     *
     * @param num number object
     * @param e1  E1 object
     */
    public E(NumToken num, E1 e1) {
        _num = num;
        _e1 = e1;
    }

    /**
     * Return a string representation.
     *
     * @return string representation
     */
    public String toString() {
        return _num.toString() + _e1.toString();
    }
}

